/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class scaleCanvasDialog
extends JDialog
implements ActionListener,
ChangeListener {
    public int scrWidth;
    public int scrHeight;
    public int orgWidth;
    public int orgHeight;
    public boolean aspectRatio = true;
    private String result;
    private JSpinner widthSpinner;
    private JSpinner heightSpinner;
    private JCheckBox ratioCheckBox;

    public scaleCanvasDialog(int n, int n2) {
        super((Frame)null, "microLcd Scale Canvas");
        this.orgWidth = n;
        this.orgHeight = n2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        this.ratioCheckBox = new JCheckBox("Fix Aspect Ratio");
        this.ratioCheckBox.setSelected(this.aspectRatio);
        this.ratioCheckBox.addActionListener(this);
        this.ratioCheckBox.setActionCommand("aspectRatio");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel.add((Component)this.ratioCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)new JLabel("Original"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)new JLabel("New"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(this.orgWidth, 1, 9999, 1));
        jSpinner.setEnabled(false);
        jPanel.add((Component)jSpinner, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        JSpinner jSpinner2 = new JSpinner(new SpinnerNumberModel(this.orgHeight, 1, 9999, 1));
        jSpinner2.setEnabled(false);
        jPanel.add((Component)jSpinner2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel("Width"), gridBagConstraints);
        this.widthSpinner = new JSpinner(new SpinnerNumberModel(n, 1, 9999, 1));
        this.widthSpinner.addChangeListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.widthSpinner, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel("Height"), gridBagConstraints);
        this.heightSpinner = new JSpinner(new SpinnerNumberModel(n2, 1, 9999, 1));
        this.heightSpinner.addChangeListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.heightSpinner, gridBagConstraints);
        JButton jButton = new JButton("OK");
        jButton.addActionListener(this);
        jButton.setActionCommand("OK");
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(this);
        jButton2.setActionCommand("Cancel");
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "Last");
    }

    public String GetResult() {
        return this.result;
    }

    public int GetNewWidth() {
        return this.scrWidth;
    }

    public int GetNewHeight() {
        return this.scrHeight;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JSpinner jSpinner = (JSpinner)changeEvent.getSource();
        if (this.ratioCheckBox.isSelected()) {
            if (jSpinner == this.widthSpinner) {
                this.heightSpinner.removeChangeListener(this);
                int n = (Integer)this.widthSpinner.getValue();
                this.heightSpinner.setValue(n * this.orgHeight / this.orgWidth);
                this.heightSpinner.addChangeListener(this);
            } else if (jSpinner == this.heightSpinner) {
                this.widthSpinner.removeChangeListener(this);
                int n = (Integer)this.heightSpinner.getValue();
                this.widthSpinner.setValue(n * this.orgWidth / this.orgHeight);
                this.widthSpinner.addChangeListener(this);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.scrWidth = (Integer)this.widthSpinner.getValue();
            this.scrHeight = (Integer)this.heightSpinner.getValue();
            this.result = "OK";
            this.dispose();
        } else if (string.equals("Cancel")) {
            this.result = "Cancel";
            this.dispose();
        } else if (string.equals("aspectRatio")) {
            // empty if block
        }
    }
}

