/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

class Window
extends JFrame
implements ActionListener,
MouseListener,
WindowListener {
    JStatusBar statusBar;
    JMenuBar menubar;
    JMenu filemenu;
    JMenu editmenu;
    JMenu imagemenu;
    JMenu helpmenu;
    JMenuItem newItem;
    JMenuItem openItem;
    JMenuItem closeItem;
    JMenuItem saveItem;
    JMenuItem saveAsItem;
    JMenuItem exportItem;
    JMenuItem cropItem;
    JMenuItem convert1Item;
    JMenuItem scaleItem;
    JMenuItem resizeItem;
    JMenuItem aboutItem;
    JButton newButton;
    JButton openButton;
    JButton saveButton;
    JButton exportButton;
    JButton copyButton;
    JButton pasteButton;
    JButton negativeButton;
    JButton clearButton;
    JButton undoButton;
    JButton redoButton;
    JButton rShiftButton;
    JButton lShiftButton;
    JButton shiftUpButton;
    JButton shiftDownButton;
    JButton gridButton;
    JButton zoomGridButton;
    JButton zoomInButton;
    JButton zoomOutButton;
    JButton hFlipButton;
    JButton vFlipButton;
    JComboBox penSizeComboBox;
    JToolBar toolBarH;
    JToolBar toolBarV;
    JToggleButton penButton;
    JToggleButton lineButton;
    JToggleButton rectButton;
    JToggleButton circleButton;
    JToggleButton fillButton;
    JToggleButton textButton;
    JToggleButton selectButton;
    LcdScreen screen;

    Window() {
        this.addWindowListener(this);
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource("images/microlcd-icon.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setIconImage(imageIcon.getImage());
        this.statusBar = new JStatusBar();
        this.screen = new LcdScreen();
        this.screen.fileName = "New";
        this.setTitle(this.screen.fileName + " - Micro LCD");
        this.menubar = new JMenuBar();
        this.filemenu = new JMenu("File");
        this.filemenu.add(new JSeparator());
        this.imagemenu = new JMenu("Image");
        this.imagemenu.add(new JSeparator());
        this.helpmenu = new JMenu("Help");
        this.helpmenu.add(new JSeparator());
        this.newItem = new JMenuItem("New");
        this.newItem.addActionListener(this);
        this.newItem.setActionCommand("New");
        this.openItem = new JMenuItem("Open");
        this.openItem.addActionListener(this);
        this.openItem.setActionCommand("Open");
        this.exportItem = new JMenuItem("Export ( .C hex file )");
        this.exportItem.addActionListener(this);
        this.exportItem.setActionCommand("Export");
        this.closeItem = new JMenuItem("Quit");
        this.closeItem.addActionListener(this);
        this.closeItem.setActionCommand("Quit");
        this.closeItem.add(new JSeparator());
        this.saveItem = new JMenuItem("Save");
        this.saveItem.addActionListener(this);
        this.saveItem.setActionCommand("Save");
        this.saveAsItem = new JMenuItem("Save As");
        this.saveAsItem.addActionListener(this);
        this.saveAsItem.setActionCommand("SaveAs");
        this.filemenu.add(this.newItem);
        this.filemenu.add(this.openItem);
        this.filemenu.add(this.saveItem);
        this.filemenu.add(this.saveAsItem);
        this.filemenu.add(this.exportItem);
        this.filemenu.add(this.closeItem);
        this.convert1Item = new JMenuItem("Convert to 1-bit color");
        this.convert1Item.addActionListener(this);
        this.convert1Item.setActionCommand("convert1");
        this.imagemenu.add(this.convert1Item);
        this.scaleItem = new JMenuItem("Scale");
        this.scaleItem.addActionListener(this);
        this.scaleItem.setActionCommand("scaleCanvas");
        this.scaleItem.add(new JSeparator());
        this.imagemenu.add(this.scaleItem);
        this.resizeItem = new JMenuItem("Resize");
        this.resizeItem.addActionListener(this);
        this.resizeItem.setActionCommand("resizeCanvas");
        this.imagemenu.add(this.resizeItem);
        this.cropItem = new JMenuItem("Crop");
        this.cropItem.addActionListener(this);
        this.cropItem.setActionCommand("Crop");
        this.imagemenu.add(this.cropItem);
        this.aboutItem = new JMenuItem("About");
        this.aboutItem.addActionListener(this);
        this.aboutItem.setActionCommand("About");
        this.helpmenu.add(this.aboutItem);
        this.menubar.add(this.filemenu);
        this.menubar.add(this.imagemenu);
        this.menubar.add(this.helpmenu);
        this.setJMenuBar(this.menubar);
        this.toolBarV = new JToolBar(1);
        this.toolBarH = new JToolBar();
        uRL = classLoader.getResource("images/new-icon.png");
        ImageIcon imageIcon2 = new ImageIcon(uRL);
        this.newButton = new JButton(imageIcon2);
        this.newButton.setToolTipText("New Image");
        this.newButton.addActionListener(this);
        this.newButton.setActionCommand("New");
        this.toolBarH.add(this.newButton);
        uRL = classLoader.getResource("images/open-icon.png");
        ImageIcon imageIcon3 = new ImageIcon(uRL);
        this.openButton = new JButton(imageIcon3);
        this.openButton.setToolTipText("Open");
        this.openButton.addActionListener(this);
        this.openButton.setActionCommand("Open");
        this.toolBarH.add(this.openButton);
        uRL = classLoader.getResource("images/save-icon.png");
        ImageIcon imageIcon4 = new ImageIcon(uRL);
        this.saveButton = new JButton(imageIcon4);
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand("SaveAs");
        this.saveButton.setToolTipText("Save As");
        this.toolBarH.add(this.saveButton);
        uRL = classLoader.getResource("images/export-icon.png");
        ImageIcon imageIcon5 = new ImageIcon(uRL);
        this.exportButton = new JButton(imageIcon5);
        this.exportButton.addActionListener(this);
        this.exportButton.setActionCommand("Export");
        this.exportButton.setToolTipText("Export image to hex .C file");
        this.toolBarH.add(this.exportButton);
        this.toolBarH.addSeparator();
        uRL = classLoader.getResource("images/copy-icon.png");
        ImageIcon imageIcon6 = new ImageIcon(uRL);
        JButton jButton = new JButton(imageIcon6);
        jButton.addActionListener(this);
        jButton.setActionCommand("Copy");
        jButton.setToolTipText("Copy");
        this.toolBarH.add(jButton);
        uRL = classLoader.getResource("images/paste-icon.png");
        ImageIcon imageIcon7 = new ImageIcon(uRL);
        this.pasteButton = new JButton(imageIcon7);
        this.pasteButton.addActionListener(this);
        this.pasteButton.setActionCommand("Paste");
        this.pasteButton.setToolTipText("Paste");
        this.toolBarH.add(this.pasteButton);
        this.toolBarH.addSeparator();
        uRL = classLoader.getResource("images/negative-icon.png");
        ImageIcon imageIcon8 = new ImageIcon(uRL);
        JButton jButton2 = new JButton(imageIcon8);
        jButton2.addActionListener(this);
        jButton2.setActionCommand("Negative");
        jButton2.setToolTipText("Negative");
        this.toolBarH.add(jButton2);
        uRL = classLoader.getResource("images/delete-icon.png");
        ImageIcon imageIcon9 = new ImageIcon(uRL);
        this.clearButton = new JButton(imageIcon9);
        this.clearButton.addActionListener(this);
        this.clearButton.setActionCommand("Clear");
        this.clearButton.setToolTipText("Clear");
        this.toolBarH.add(this.clearButton);
        this.toolBarH.addSeparator();
        uRL = classLoader.getResource("images/undo-icon.png");
        ImageIcon imageIcon10 = new ImageIcon(uRL);
        this.undoButton = new JButton(imageIcon10);
        this.undoButton.addActionListener(this);
        this.undoButton.setActionCommand("Undo");
        this.undoButton.setToolTipText("Undo");
        this.toolBarH.add(this.undoButton);
        uRL = classLoader.getResource("images/redo-icon.png");
        ImageIcon imageIcon11 = new ImageIcon(uRL);
        this.redoButton = new JButton(imageIcon11);
        this.redoButton.addActionListener(this);
        this.redoButton.setActionCommand("Redo");
        this.redoButton.setToolTipText("Redo");
        this.toolBarH.add(this.redoButton);
        this.toolBarH.addSeparator();
        uRL = classLoader.getResource("images/zoom-in-icon.png");
        ImageIcon imageIcon12 = new ImageIcon(uRL);
        this.zoomInButton = new JButton(imageIcon12);
        this.zoomInButton.addActionListener(this);
        this.zoomInButton.setActionCommand("zoomIn");
        this.zoomInButton.setToolTipText("Zoom In");
        this.toolBarH.add(this.zoomInButton);
        uRL = classLoader.getResource("images/zoom-out-icon.png");
        ImageIcon imageIcon13 = new ImageIcon(uRL);
        this.zoomOutButton = new JButton(imageIcon13);
        this.zoomOutButton.addActionListener(this);
        this.zoomOutButton.setActionCommand("zoomOut");
        this.zoomOutButton.setToolTipText("Zoom Out");
        this.toolBarH.add(this.zoomOutButton);
        this.toolBarH.addSeparator();
        uRL = classLoader.getResource("images/grid-icon.png");
        ImageIcon imageIcon14 = new ImageIcon(uRL);
        this.gridButton = new JButton(imageIcon14);
        this.gridButton.setToolTipText("Grid");
        this.gridButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16) {
                    Window.this.screen.gridSwitch();
                    Window.this.screen.repaint();
                } else if (mouseEvent.getModifiers() == 4) {
                    gridDialog gridDialog2 = new gridDialog(Window.this.screen.gridWidth, Window.this.screen.gridHeight, Window.this.screen.Grid);
                    gridDialog2.setModal(true);
                    gridDialog2.setLocation(100, 100);
                    gridDialog2.setResizable(false);
                    gridDialog2.pack();
                    gridDialog2.setVisible(true);
                    if (gridDialog2.GetResult() == "OK") {
                        Window.this.screen.gridWidth = gridDialog2.GetGridWidth();
                        Window.this.screen.gridHeight = gridDialog2.GetGridHeight();
                        Window.this.screen.Grid = gridDialog2.GetShowGrid();
                        Window.this.screen.repaint();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.toolBarH.add(this.gridButton);
        uRL = classLoader.getResource("images/pixelgrid-icon.png");
        ImageIcon imageIcon15 = new ImageIcon(uRL);
        this.zoomGridButton = new JButton(imageIcon15);
        this.zoomGridButton.addActionListener(this);
        this.zoomGridButton.setActionCommand("zoomGridChange");
        this.zoomGridButton.setToolTipText("Pixel Grid");
        this.toolBarH.add(this.zoomGridButton);
        this.toolBarH.addSeparator();
        Integer[] integerArray = new Integer[]{1, 2, 3, 4, 5};
        this.penSizeComboBox = new JComboBox<Integer>(integerArray);
        this.penSizeComboBox.addActionListener(this);
        this.penSizeComboBox.setActionCommand("penSizeChange");
        this.penSizeComboBox.setMinimumSize(new Dimension(40, 20));
        this.penSizeComboBox.setMaximumSize(new Dimension(40, 20));
        this.penSizeComboBox.setSelectedIndex(0);
        this.toolBarH.add(new JLabel("Pen"));
        this.toolBarH.add(this.penSizeComboBox);
        this.toolBarH.addSeparator();
        uRL = classLoader.getResource("images/lshift-icon.png");
        ImageIcon imageIcon16 = new ImageIcon(uRL);
        this.lShiftButton = new JButton(imageIcon16);
        this.lShiftButton.setToolTipText("Move Left");
        this.lShiftButton.addActionListener(this);
        this.lShiftButton.setActionCommand("LShift");
        this.toolBarH.add(this.lShiftButton);
        uRL = classLoader.getResource("images/rshift-icon.png");
        ImageIcon imageIcon17 = new ImageIcon(uRL);
        this.rShiftButton = new JButton(imageIcon17);
        this.rShiftButton.setToolTipText("Move Right");
        this.rShiftButton.addActionListener(this);
        this.rShiftButton.setActionCommand("RShift");
        this.toolBarH.add(this.rShiftButton);
        uRL = classLoader.getResource("images/shiftup-icon.png");
        ImageIcon imageIcon18 = new ImageIcon(uRL);
        this.shiftUpButton = new JButton(imageIcon18);
        this.shiftUpButton.setToolTipText("Move Up");
        this.shiftUpButton.addActionListener(this);
        this.shiftUpButton.setActionCommand("shiftUp");
        this.toolBarH.add(this.shiftUpButton);
        uRL = classLoader.getResource("images/shiftdown-icon.png");
        ImageIcon imageIcon19 = new ImageIcon(uRL);
        this.shiftDownButton = new JButton(imageIcon19);
        this.shiftDownButton.setToolTipText("Move Down");
        this.shiftDownButton.addActionListener(this);
        this.shiftDownButton.setActionCommand("shiftDown");
        this.toolBarH.add(this.shiftDownButton);
        this.toolBarH.addSeparator();
        uRL = classLoader.getResource("images/hflip-icon.png");
        ImageIcon imageIcon20 = new ImageIcon(uRL);
        this.hFlipButton = new JButton(imageIcon20);
        this.hFlipButton.setToolTipText("Horizontal Flip");
        this.hFlipButton.addActionListener(this);
        this.hFlipButton.setActionCommand("HorizontalFlip");
        this.toolBarH.add(this.hFlipButton);
        uRL = classLoader.getResource("images/vflip-icon.png");
        ImageIcon imageIcon21 = new ImageIcon(uRL);
        this.vFlipButton = new JButton(imageIcon21);
        this.vFlipButton.setToolTipText("Vertical Flip");
        this.vFlipButton.addActionListener(this);
        this.vFlipButton.setActionCommand("VerticalFlip");
        this.toolBarH.add(this.vFlipButton);
        this.toolBarH.addSeparator();
        uRL = classLoader.getResource("images/select-icon.png");
        ImageIcon imageIcon22 = new ImageIcon(uRL);
        this.selectButton = new JToggleButton(imageIcon22);
        this.selectButton.addActionListener(this);
        this.selectButton.setToolTipText("Select");
        this.selectButton.setActionCommand("setSelectTool");
        this.selectButton.setSelected(true);
        this.toolBarV.add(this.selectButton);
        uRL = classLoader.getResource("images/pen-icon.png");
        ImageIcon imageIcon23 = new ImageIcon(uRL);
        this.penButton = new JToggleButton(imageIcon23);
        this.penButton.setToolTipText("Free Draw");
        this.penButton.addActionListener(this);
        this.penButton.setActionCommand("setPenTool");
        this.penButton.setSelected(true);
        this.toolBarV.add(this.penButton);
        uRL = classLoader.getResource("images/line-icon.png");
        ImageIcon imageIcon24 = new ImageIcon(uRL);
        this.lineButton = new JToggleButton(imageIcon24);
        this.lineButton.addActionListener(this);
        this.lineButton.setToolTipText("Line");
        this.lineButton.setActionCommand("setLineTool");
        this.toolBarV.add(this.lineButton);
        uRL = classLoader.getResource("images/rect-icon.png");
        ImageIcon imageIcon25 = new ImageIcon(uRL);
        this.rectButton = new JToggleButton(imageIcon25);
        this.rectButton.addActionListener(this);
        this.rectButton.setToolTipText("Rectangle");
        this.rectButton.setActionCommand("setRectTool");
        this.toolBarV.add(this.rectButton);
        uRL = classLoader.getResource("images/circle-icon.png");
        ImageIcon imageIcon26 = new ImageIcon(uRL);
        this.circleButton = new JToggleButton(imageIcon26);
        this.circleButton.setToolTipText("Oval");
        this.circleButton.addActionListener(this);
        this.circleButton.setActionCommand("setCircleTool");
        this.circleButton.addMouseListener(this);
        this.toolBarV.add(this.circleButton);
        uRL = classLoader.getResource("images/fill-icon.png");
        ImageIcon imageIcon27 = new ImageIcon(uRL);
        this.fillButton = new JToggleButton(imageIcon27);
        this.fillButton.addActionListener(this);
        this.fillButton.setToolTipText("Fill");
        this.fillButton.setActionCommand("setFillTool");
        this.toolBarV.add(this.fillButton);
        uRL = classLoader.getResource("images/text-icon.png");
        ImageIcon imageIcon28 = new ImageIcon(uRL);
        this.textButton = new JToggleButton(imageIcon28);
        this.textButton.setToolTipText("Text");
        this.textButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16) {
                    Window.this.screen.tool = "text";
                    Window.this.screen.setCursor(Cursor.getPredefinedCursor(1));
                    Window.this.screen.noneSelect();
                } else if (mouseEvent.getModifiers() == 4) {
                    textDialog textDialog2 = new textDialog(Window.this.screen.myText, Window.this.screen.myFont);
                    textDialog2.setModal(true);
                    textDialog2.setLocation(100, 100);
                    textDialog2.setResizable(false);
                    textDialog2.pack();
                    textDialog2.setVisible(true);
                    if (textDialog2.getResult() == "OK") {
                        Window.this.screen.myText = textDialog2.getText();
                        Font font = textDialog2.getFont();
                        if (font != null) {
                            Window.this.screen.myFont = font;
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.toolBarV.add(this.textButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.selectButton);
        buttonGroup.add(this.penButton);
        buttonGroup.add(this.lineButton);
        buttonGroup.add(this.circleButton);
        buttonGroup.add(this.rectButton);
        buttonGroup.add(this.fillButton);
        buttonGroup.add(this.textButton);
        this.add((Component)this.toolBarH, "First");
        this.add((Component)this.toolBarV, "West");
        this.add((Component)this.statusBar, "South");
        JScrollPane jScrollPane = new JScrollPane(this.screen);
        this.screen.statusBar = this.statusBar;
        jScrollPane.setPreferredSize(new Dimension(720, 480));
        this.add(jScrollPane);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("New")) {
            newDialog newDialog2 = new newDialog(this.screen.Width, this.screen.Height);
            newDialog2.setModal(true);
            newDialog2.setLocation(100, 100);
            newDialog2.setResizable(false);
            newDialog2.pack();
            newDialog2.setVisible(true);
            if (newDialog2.GetResult() == "OK") {
                int n = newDialog2.getLcdScreenWidth();
                int n2 = newDialog2.getLcdScreenHeight();
                this.screen.Width = n;
                this.screen.Height = n2;
                this.screen.fileName = "New";
                this.setTitle(this.screen.fileName + " - Micro LCD");
                this.screen.New();
                this.screen.repaint();
            }
        } else if (string.equals("Open")) {
            JFileChooser jFileChooser = new JFileChooser(this.screen.directoryName);
            jFileChooser.addChoosableFileFilter(new ImageFilter());
            jFileChooser.setAccessory(new ImagePreview(jFileChooser));
            jFileChooser.setFileView(new ImageFileView());
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.screen.openImage(file);
                this.screen.fileName = file.getPath();
                this.screen.directoryName = file.getAbsolutePath();
                this.setTitle(this.screen.fileName + " - Micro LCD");
                this.screen.repaint();
            }
        } else if (string.equals("Export")) {
            JFileChooser jFileChooser;
            int n;
            exportDialog exportDialog2 = new exportDialog();
            exportDialog2.setModal(true);
            exportDialog2.setLocation(100, 100);
            exportDialog2.setResizable(false);
            exportDialog2.pack();
            exportDialog2.setVisible(true);
            if (exportDialog2.GetResult() == "OK" && (n = (jFileChooser = new JFileChooser(this.screen.exportDirectoryName)).showSaveDialog(this)) == 0) {
                int n3 = exportDialog2.GetModel();
                File file = jFileChooser.getSelectedFile();
                this.screen.toHexFile(file.getPath(), n3);
                this.screen.exportDirectoryName = file.getAbsolutePath();
            }
        } else if (string.equals("Save")) {
            if (this.screen.fileName != "New") {
                File file = new File(this.screen.fileName);
                this.screen.saveImage(file);
            } else {
                JFileChooser jFileChooser = new JFileChooser(this.screen.directoryName);
                jFileChooser.setAccessory(new ImagePreview(jFileChooser));
                int n = jFileChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    this.screen.saveImage(file);
                    this.screen.fileName = file.getPath();
                    this.screen.directoryName = file.getAbsolutePath();
                    this.setTitle(this.screen.fileName + " - Micro LCD");
                }
            }
        } else if (string.equals("SaveAs")) {
            JFileChooser jFileChooser = new JFileChooser(this.screen.directoryName);
            jFileChooser.setAccessory(new ImagePreview(jFileChooser));
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.screen.saveImage(file);
                this.screen.fileName = file.getPath();
                this.screen.directoryName = file.getAbsolutePath();
                this.setTitle(this.screen.fileName + " - Micro LCD");
            }
        } else if (string.equals("penSizeChange")) {
            this.screen.penSize = (Integer)this.penSizeComboBox.getSelectedItem();
        } else if (string.equals("Quit")) {
            this.exit();
        } else if (string.equals("About")) {
            aboutDialog aboutDialog2 = new aboutDialog();
            aboutDialog2.setModal(true);
            aboutDialog2.setLocation(100, 100);
            aboutDialog2.setResizable(false);
            aboutDialog2.pack();
            aboutDialog2.setVisible(true);
        } else if (string.equals("Copy")) {
            this.screen.copyImage();
        } else if (string.equals("Paste")) {
            if (this.screen.pasteImage() != -1) {
                this.screen.undoCopy();
            }
        } else if (string.equals("Negative")) {
            this.screen.negative();
            this.screen.undoCopy();
        } else if (string.equals("Clear")) {
            this.screen.Clear();
            this.screen.undoCopy();
        } else if (string.equals("Undo")) {
            this.screen.undoBack();
            this.screen.repaint();
        } else if (string.equals("Redo")) {
            this.screen.redoBack();
            this.screen.repaint();
        } else if (string.equals("RShift")) {
            this.screen.RShift();
            this.screen.undoCopy();
        } else if (string.equals("LShift")) {
            this.screen.LShift();
            this.screen.undoCopy();
        } else if (string.equals("shiftUp")) {
            this.screen.shiftUp();
            this.screen.undoCopy();
        } else if (string.equals("shiftDown")) {
            this.screen.shiftDown();
            this.screen.undoCopy();
        } else if (string.equals("VerticalFlip")) {
            this.screen.vFlip();
            this.screen.undoCopy();
        } else if (string.equals("HorizontalFlip")) {
            this.screen.hFlip();
            this.screen.undoCopy();
        } else if (string.equals("zoomIn")) {
            if (this.screen.zoom < 20) {
                ++this.screen.zoom;
                int n = this.screen.zoom;
                int n4 = this.screen.zoom;
                this.screen.setPreferredSize(new Dimension(this.screen.Width * n + 40, this.screen.Height * n4 + 40));
                this.screen.revalidate();
                this.screen.repaint();
            }
        } else if (string.equals("zoomOut")) {
            if (this.screen.zoom > 1) {
                --this.screen.zoom;
                int n = this.screen.zoom;
                int n5 = this.screen.zoom;
                this.screen.setPreferredSize(new Dimension(this.screen.Width * n + 40, this.screen.Height * n5 + 40));
                this.screen.revalidate();
                this.screen.repaint();
            }
        } else if (string.equals("zoomGridChange")) {
            this.screen.zoomGridSwitch();
            this.screen.repaint();
        } else if (string.equals("setSelectTool")) {
            this.screen.tool = "select";
            this.screen.setCursor(Cursor.getPredefinedCursor(1));
            this.screen.noneSelect();
        } else if (string.equals("setPenTool")) {
            this.screen.tool = "pen";
            this.screen.setCursor(Cursor.getPredefinedCursor(1));
            this.screen.noneSelect();
        } else if (string.equals("setLineTool")) {
            this.screen.tool = "line";
            this.screen.setCursor(Cursor.getPredefinedCursor(1));
            this.screen.noneSelect();
        } else if (string.equals("setRectTool")) {
            this.screen.tool = "rect";
            this.screen.setCursor(Cursor.getPredefinedCursor(1));
            this.screen.noneSelect();
        } else if (string.equals("setCircleTool")) {
            this.screen.tool = "circle";
            this.screen.setCursor(Cursor.getPredefinedCursor(1));
            this.screen.noneSelect();
        } else if (string.equals("setFillTool")) {
            this.screen.tool = "fill";
            this.screen.setCursor(Cursor.getPredefinedCursor(1));
            this.screen.noneSelect();
        } else if (string.equals("scaleCanvas")) {
            scaleCanvasDialog scaleCanvasDialog2 = new scaleCanvasDialog(this.screen.Width, this.screen.Height);
            scaleCanvasDialog2.setModal(true);
            scaleCanvasDialog2.setLocation(100, 100);
            scaleCanvasDialog2.setResizable(false);
            scaleCanvasDialog2.pack();
            scaleCanvasDialog2.setVisible(true);
            if (scaleCanvasDialog2.GetResult() == "OK") {
                int n = scaleCanvasDialog2.GetNewWidth();
                int n6 = scaleCanvasDialog2.GetNewHeight();
                this.screen.scaleCanvas(n, n6);
                this.screen.undoCopy();
            }
        } else if (string.equals("resizeCanvas")) {
            resizeCanvasDialog resizeCanvasDialog2 = new resizeCanvasDialog(this.screen.Width, this.screen.Height);
            resizeCanvasDialog2.setModal(true);
            resizeCanvasDialog2.setLocation(100, 100);
            resizeCanvasDialog2.setResizable(false);
            resizeCanvasDialog2.pack();
            resizeCanvasDialog2.setVisible(true);
            if (resizeCanvasDialog2.GetResult() == "OK") {
                int n = resizeCanvasDialog2.GetNewWidth();
                int n7 = resizeCanvasDialog2.GetNewHeight();
                this.screen.resizeCanvas(n, n7);
                this.screen.undoCopy();
            }
        } else if (string.equals("convert1")) {
            convert1Dialog convert1Dialog2 = new convert1Dialog();
            convert1Dialog2.setModal(true);
            convert1Dialog2.setLocation(100, 100);
            convert1Dialog2.setResizable(false);
            convert1Dialog2.pack();
            convert1Dialog2.setVisible(true);
            if (convert1Dialog2.GetResult() == "OK") {
                int n = convert1Dialog2.GetThreshold();
                this.screen.convert2BandW(n);
                this.screen.undoCopy();
            }
        } else if (string.equals("Crop")) {
            if (this.screen.selX2 - this.screen.selX1 == 0 || this.screen.selY2 - this.screen.selY1 == 0) {
                JOptionPane.showMessageDialog(null, "First select an area of an image");
            } else if (this.screen.Crop() == 0) {
                this.screen.undoCopy();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() != 16 && mouseEvent.getModifiers() == 4) {
            System.out.println("Prawe ko\u0142o");
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.exit();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void exit() {
        int n = JOptionPane.showConfirmDialog(null, "Are you sure you want to quit?", "Confirm Quit", 0, 2);
        if (n == 0) {
            System.exit(0);
        }
    }
}

