/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class LcdScreen
extends JPanel {
    public JStatusBar statusBar;
    private BufferedImage bImage;
    private BufferedImage copyImage;
    private int undoIndex = 0;
    private int redoIndex = 0;
    private int undoMax = 20;
    private BufferedImage[] undoBuf = new BufferedImage[this.undoMax];
    public boolean changeFlag = false;
    String fileName;
    String directoryName = "...";
    String exportDirectoryName = "...";
    public int Width = 84;
    public int Height = 48;
    private int xo = 20;
    private int yo = 20;
    public boolean zoomGrid = true;
    public boolean Grid = true;
    public int gridWidth = 6;
    public int gridHeight = 8;
    int zoom = 8;
    public String tool = "select";
    public boolean toolLMClick = false;
    public int penSize = 1;
    public String myText = "Text";
    public Font myFont = new Font("monospaced", 0, 11);
    public int selX1;
    public int selY1;
    public int selX2;
    public int selY2;
    public Color selColor = new Color(0);

    public boolean gridSwitch() {
        this.Grid = !this.Grid;
        return this.Grid;
    }

    public boolean zoomGridSwitch() {
        this.zoomGrid = !this.zoomGrid;
        return this.zoomGrid;
    }

    public void noneSelect() {
        this.selY2 = 0;
        this.selX2 = 0;
        this.selY1 = 0;
        this.selX1 = 0;
        this.copyImage = null;
        this.repaint();
    }

    public int copyImage() {
        int n;
        int n2 = this.selX1;
        int n3 = this.selY1;
        int n4 = this.selX2;
        int n5 = this.selY2;
        if (n4 < n2) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n5 < n3) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        if (n6 == 0 || n7 == 0) {
            this.noneSelect();
            return -1;
        }
        this.copyImage = new BufferedImage(n6, n7, 1);
        this.copyImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)this.copyImage.getGraphics();
        graphics2D.drawImage(this.bImage, 0, 0, n6, n7, n2, n3, n4, n5, null);
        graphics2D.dispose();
        return 0;
    }

    public int pasteImage() {
        int n;
        if (this.copyImage == null) {
            return -1;
        }
        int n2 = this.selX1;
        int n3 = this.selY1;
        int n4 = this.selX2;
        int n5 = this.selY2;
        if (n4 < n2) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n5 < n3) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        this.bImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.drawImage((Image)this.copyImage, n2, n3, this);
        graphics2D.dispose();
        this.repaint();
        return 0;
    }

    public void resizeCanvas(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        bufferedImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(this.bImage, 0, 0, this.Width, this.Height, 0, 0, this.Width, this.Height, null);
        graphics2D.dispose();
        this.bImage = bufferedImage;
        this.Width = n;
        this.Height = n2;
        int n3 = this.zoom;
        int n4 = this.zoom;
        this.setPreferredSize(new Dimension(this.Width * n3 + 40, this.Height * n4 + 40));
        this.revalidate();
        this.repaint();
    }

    public void scaleCanvas(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        bufferedImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(this.bImage, 0, 0, n, n2, 0, 0, this.Width, this.Height, null);
        graphics2D.dispose();
        this.bImage = bufferedImage;
        this.Width = n;
        this.Height = n2;
        int n3 = this.zoom;
        int n4 = this.zoom;
        this.setPreferredSize(new Dimension(this.Width * n3 + 40, this.Height * n4 + 40));
        this.revalidate();
        this.repaint();
    }

    public boolean isUndoEnable() {
        return this.undoIndex > 0;
    }

    public boolean isRedoEnable() {
        return this.redoIndex > 0;
    }

    public void redoBack() {
        if (this.redoIndex > 0) {
            ++this.undoIndex;
            this.Width = this.undoBuf[this.undoIndex].getWidth(null);
            this.Height = this.undoBuf[this.undoIndex].getHeight(null);
            this.bImage = null;
            this.bImage = new BufferedImage(this.Width, this.Height, 1);
            Graphics2D graphics2D = (Graphics2D)this.bImage.getGraphics();
            graphics2D.drawImage((Image)this.undoBuf[this.undoIndex], 0, 0, this);
            graphics2D.dispose();
            this.repaint();
            --this.redoIndex;
            System.out.println(this.undoIndex);
        }
    }

    public void undoBack() {
        if (this.undoIndex > 0) {
            --this.undoIndex;
            this.Width = this.undoBuf[this.undoIndex].getWidth(null);
            this.Height = this.undoBuf[this.undoIndex].getHeight(null);
            this.bImage = null;
            this.bImage = new BufferedImage(this.Width, this.Height, 1);
            Graphics2D graphics2D = (Graphics2D)this.bImage.getGraphics();
            graphics2D.drawImage((Image)this.undoBuf[this.undoIndex], 0, 0, this);
            graphics2D.dispose();
            this.repaint();
            ++this.redoIndex;
            System.out.println(this.undoIndex);
        }
    }

    public void undoCopy() {
        if (this.undoIndex < this.undoMax - 1) {
            ++this.undoIndex;
            this.undoBuf[this.undoIndex] = new BufferedImage(this.Width, this.Height, 1);
            this.undoBuf[this.undoIndex].createGraphics();
            Graphics2D graphics2D = (Graphics2D)this.undoBuf[this.undoIndex].getGraphics();
            graphics2D.drawImage((Image)this.bImage, 0, 0, this);
            graphics2D.dispose();
        } else {
            BufferedImage bufferedImage = this.undoBuf[0];
            for (int i = 0; i < this.undoIndex; ++i) {
                this.undoBuf[i] = this.undoBuf[i + 1];
            }
            this.undoBuf[this.undoIndex] = bufferedImage;
            this.undoBuf[this.undoIndex].createGraphics();
            this.undoBuf[this.undoIndex] = new BufferedImage(this.Width, this.Height, 1);
            this.undoBuf[this.undoIndex].createGraphics();
            Graphics2D graphics2D = (Graphics2D)this.undoBuf[this.undoIndex].getGraphics();
            graphics2D.drawImage((Image)this.bImage, 0, 0, this);
            graphics2D.dispose();
        }
        this.redoIndex = 0;
        this.changeFlag = true;
        System.out.println(this.undoIndex);
    }

    void saveImage(File file) {
        try {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            if (string != null) {
                ImageIO.write((RenderedImage)this.bImage, string, file);
            } else {
                ImageIO.write((RenderedImage)this.bImage, "png", file);
            }
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(null, "ERROR - cz\u0142owieku!");
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "ERROR - cz\u0142owieku!");
        }
    }

    void openImage(File file) {
        this.undoIndex = 0;
        this.redoIndex = 0;
        for (int i = 0; i < 10; ++i) {
            this.undoBuf[0] = null;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            this.Width = bufferedImage.getWidth(null);
            this.Height = bufferedImage.getHeight(null);
            this.bImage = new BufferedImage(this.Width, this.Height, 1);
            this.bImage.createGraphics();
            Graphics2D graphics2D = (Graphics2D)this.bImage.getGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, this);
            graphics2D.dispose();
            this.undoBuf[0] = new BufferedImage(this.Width, this.Height, 1);
            this.undoBuf[0].createGraphics();
            graphics2D = (Graphics2D)this.undoBuf[0].getGraphics();
            graphics2D.drawImage((Image)this.bImage, 0, 0, this);
            graphics2D.dispose();
            int n = this.zoom;
            int n2 = this.zoom;
            this.setPreferredSize(new Dimension(this.Width * n + 40, this.Height * n2 + 40));
            this.revalidate();
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(null, "ERROR!");
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "ERROR!");
        }
    }

    void toHexFile(String string, int n) {
        int n2;
        int[] nArray = null;
        switch (n) {
            case 0: {
                int n3;
                int n4;
                int n5;
                int n6;
                n2 = this.Width * (this.Height / 8);
                if (this.Height % 8 > 0) {
                    n2 += this.Width;
                }
                nArray = new int[n2];
                int n7 = 0;
                for (n6 = 0; n6 < (this.Height & 0xFFFFFFF8); n6 += 8) {
                    n5 = 0;
                    while (n5 < this.Width) {
                        n4 = 0;
                        n3 = 1;
                        nArray[n7] = 0;
                        while (n4 < 8) {
                            if ((this.bImage.getRGB(n5, n6 + n4) & 0xFFFFFF) == 0) {
                                int n8 = n7;
                                nArray[n8] = nArray[n8] + n3;
                            }
                            ++n4;
                            n3 *= 2;
                        }
                        ++n5;
                        ++n7;
                    }
                }
                if (this.Height % 8 == 0) break;
                n5 = 0;
                while (n5 < this.Width) {
                    n4 = 0;
                    n3 = 1;
                    nArray[n7] = 0;
                    while (n4 < this.Height % 8) {
                        if ((this.bImage.getRGB(n5, n6 + n4) & 0xFFFFFF) == 0) {
                            int n9 = n7;
                            nArray[n9] = nArray[n9] + n3;
                        }
                        ++n4;
                        n3 *= 2;
                    }
                    ++n5;
                    ++n7;
                }
                break;
            }
            case 1: {
                int n3;
                int n4;
                int n5;
                int n6;
                n2 = this.Width * (this.Height / 8);
                if (this.Height % 8 > 0) {
                    n2 += this.Width;
                }
                nArray = new int[n2];
                int n7 = 0;
                for (n5 = 0; n5 < this.Width; ++n5) {
                    n6 = 0;
                    while (n6 < (this.Height & 0xFFFFFFF8)) {
                        n4 = 0;
                        n3 = 1;
                        nArray[n7] = 0;
                        while (n4 < 8) {
                            if ((this.bImage.getRGB(n5, n6 + n4) & 0xFFFFFF) == 0) {
                                int n10 = n7;
                                nArray[n10] = nArray[n10] + n3;
                            }
                            ++n4;
                            n3 *= 2;
                        }
                        n6 += 8;
                        ++n7;
                    }
                    if (this.Height % 8 == 0) continue;
                    n4 = 0;
                    n3 = 1;
                    nArray[n7] = 0;
                    while (n4 < this.Height % 8) {
                        if ((this.bImage.getRGB(n5, n6 + n4) & 0xFFFFFF) == 0) {
                            int n11 = n7;
                            nArray[n11] = nArray[n11] + n3;
                        }
                        ++n4;
                        n3 *= 2;
                    }
                    ++n7;
                }
                break;
            }
            case 2: {
                int n3;
                int n4;
                int n5;
                int n6;
                n2 = this.Width / 8 * this.Height;
                if (this.Width % 8 > 0) {
                    n2 += this.Height;
                }
                nArray = new int[n2];
                int n7 = 0;
                for (n6 = 0; n6 < this.Height; ++n6) {
                    n5 = 0;
                    while (n5 < this.Width) {
                        n4 = 0;
                        n3 = 128;
                        nArray[n7] = 0;
                        while (n4 < 8) {
                            if (n5 + n4 < this.Width && (this.bImage.getRGB(n5 + n4, n6) & 0xFFFFFF) == 0) {
                                int n12 = n7;
                                nArray[n12] = nArray[n12] + n3;
                            }
                            ++n4;
                            n3 /= 2;
                        }
                        n5 += 8;
                        ++n7;
                    }
                }
                break;
            }
            case 3: {
                int n3;
                int n4;
                int n5;
                int n6;
                n2 = this.Width / 6 * this.Height;
                if (this.Width % 6 > 0) {
                    n2 += this.Height;
                }
                nArray = new int[n2];
                int n7 = 0;
                for (n6 = 0; n6 < this.Height; ++n6) {
                    n5 = 0;
                    while (n5 < this.Width) {
                        n4 = 0;
                        n3 = 32;
                        nArray[n7] = 0;
                        while (n4 < 6) {
                            if (n5 + n4 < this.Width && (this.bImage.getRGB(n5 + n4, n6) & 0xFFFFFF) == 0) {
                                int n13 = n7;
                                nArray[n13] = nArray[n13] + n3;
                            }
                            ++n4;
                            n3 /= 2;
                        }
                        n5 += 6;
                        ++n7;
                    }
                }
                break;
            }
            case 4: {
                int n14;
                int n3;
                int n4;
                int n5;
                int n6;
                n2 = this.Width % 8 == 0 && this.Height % 8 == 0 ? this.Width / 8 * this.Height : (this.Width % 8 > 0 && this.Height % 8 == 0 ? (this.Width + 8) / 8 * this.Height : (this.Width % 8 == 0 && this.Height % 8 > 0 ? this.Width / 8 * (this.Height - this.Height % 8 + 8) : (this.Width + 8) / 8 * (this.Height - this.Height % 8 + 8)));
                nArray = new int[n2];
                int n7 = 0;
                for (n6 = 0; n6 < this.Height; n6 += 8) {
                    for (n5 = 0; n5 < this.Width; n5 += 8) {
                        n14 = 0;
                        while (n14 < 8) {
                            if (n6 + n14 < this.Height) {
                                n4 = 0;
                                n3 = 128;
                                nArray[n7] = 0;
                                while (n4 < 8) {
                                    if (n5 + n4 < this.Width && (this.bImage.getRGB(n5 + n4, n6 + n14) & 0xFFFFFF) == 0) {
                                        int n15 = n7;
                                        nArray[n15] = nArray[n15] + n3;
                                    }
                                    ++n4;
                                    n3 /= 2;
                                }
                            } else {
                                nArray[n7] = 0;
                            }
                            ++n14;
                            ++n7;
                        }
                    }
                }
                break;
            }
            case 5: {
                int n14;
                int n3;
                int n4;
                int n5;
                int n6;
                n2 = this.Width % 6 == 0 && this.Height % 8 == 0 ? this.Width / 6 * this.Height : (this.Width % 6 > 0 && this.Height % 8 == 0 ? (this.Width + 6) / 6 * this.Height : (this.Width % 6 == 0 && this.Height % 8 > 0 ? this.Width / 6 * (this.Height - this.Height % 8 + 8) : (this.Width + 6) / 6 * (this.Height - this.Height % 8 + 8)));
                nArray = new int[n2];
                int n7 = 0;
                for (n6 = 0; n6 < this.Height; n6 += 8) {
                    for (n5 = 0; n5 < this.Width; n5 += 6) {
                        n14 = 0;
                        while (n14 < 8) {
                            if (n6 + n14 < this.Height) {
                                n4 = 0;
                                n3 = 32;
                                nArray[n7] = 0;
                                while (n4 < 6) {
                                    if (n5 + n4 < this.Width && (this.bImage.getRGB(n5 + n4, n6 + n14) & 0xFFFFFF) == 0) {
                                        int n16 = n7;
                                        nArray[n16] = nArray[n16] + n3;
                                    }
                                    ++n4;
                                    n3 /= 2;
                                }
                            } else {
                                nArray[n7] = 0;
                            }
                            ++n14;
                            ++n7;
                        }
                    }
                }
                break;
            }
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string, false));
            block37: for (n2 = 0; n2 < nArray.length; ++n2) {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        if (n2 == nArray.length - 1) {
                            printWriter.printf("%#04x\n", nArray[n2]);
                            continue block37;
                        }
                        if (n2 % 16 == 15) {
                            printWriter.printf("%#04x,\n", nArray[n2]);
                            continue block37;
                        }
                        printWriter.printf("%#04x,", nArray[n2]);
                        continue block37;
                    }
                    case 4: 
                    case 5: {
                        if (n2 == nArray.length - 1) {
                            printWriter.printf("%#04x\n", nArray[n2]);
                            continue block37;
                        }
                        if (n2 % 8 == 7) {
                            printWriter.printf("%#04x,\n", nArray[n2]);
                            continue block37;
                        }
                        printWriter.printf("%#04x,", nArray[n2]);
                    }
                }
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("Error write file: " + string);
            System.exit(1);
        }
    }

    public void Clear() {
        int n;
        int n2 = this.selX1;
        int n3 = this.selY1;
        int n4 = this.selX2;
        int n5 = this.selY2;
        if (n4 < n2) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n5 < n3) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        if (n6 == 0 || n7 == 0) {
            n2 = 0;
            n3 = 0;
            n4 = this.Width;
            n5 = this.Height;
            n6 = this.Width;
            n7 = this.Height;
        }
        Graphics2D graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.setColor(new Color(0xFFFFFF));
        graphics2D.fillRect(n2, n3, n6, n7);
        graphics2D.dispose();
        this.repaint();
    }

    public void New() {
        this.undoIndex = 0;
        this.redoIndex = 0;
        for (int i = 0; i < this.undoMax; ++i) {
            this.undoBuf[0] = null;
        }
        this.undoBuf[0] = new BufferedImage(this.Width, this.Height, 1);
        this.undoBuf[0].createGraphics();
        Graphics2D graphics2D = (Graphics2D)this.undoBuf[0].getGraphics();
        graphics2D.setColor(new Color(0xFFFFFF));
        graphics2D.fillRect(0, 0, this.Width, this.Height);
        graphics2D.dispose();
        this.bImage = new BufferedImage(this.Width, this.Height, 1);
        this.bImage.createGraphics();
        graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.setColor(new Color(0xFFFFFF));
        graphics2D.fillRect(0, 0, this.Width, this.Height);
        graphics2D.dispose();
        int n = this.zoom;
        int n2 = this.zoom;
        this.setPreferredSize(new Dimension(this.Width * n + 40, this.Height * n2 + 40));
        this.revalidate();
        this.repaint();
    }

    public LcdScreen() {
        this.bImage = new BufferedImage(this.Width, this.Height, 1);
        this.bImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.setColor(new Color(0xFFFFFF));
        graphics2D.fillRect(0, 0, this.Width, this.Height);
        graphics2D.dispose();
        this.undoBuf[0] = new BufferedImage(this.Width, this.Height, 1);
        this.undoBuf[0].createGraphics();
        graphics2D = (Graphics2D)this.undoBuf[0].getGraphics();
        graphics2D.drawImage((Image)this.bImage, 0, 0, this);
        graphics2D.dispose();
        int n = this.zoom;
        int n2 = this.zoom;
        this.setPreferredSize(new Dimension(this.Width * n + 40, this.Height * n2 + 40));
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = LcdScreen.this.zoom;
                int n4 = LcdScreen.this.zoom;
                int n5 = (n - LcdScreen.this.xo) / n3;
                int n6 = (n2 - LcdScreen.this.yo) / n4;
                if (LcdScreen.this.tool == "select") {
                    if (n < LcdScreen.this.xo) {
                        n = LcdScreen.this.xo;
                    }
                    if (n2 < LcdScreen.this.xo) {
                        n2 = LcdScreen.this.yo;
                    }
                    if (n > LcdScreen.this.xo + LcdScreen.this.Width * n3) {
                        n = LcdScreen.this.xo + LcdScreen.this.Width * n3;
                    }
                    if (n2 > LcdScreen.this.yo + LcdScreen.this.Height * n4) {
                        n2 = LcdScreen.this.yo + LcdScreen.this.Height * n4;
                    }
                    n5 = (n - LcdScreen.this.xo) / n3;
                    n6 = (n2 - LcdScreen.this.yo) / n4;
                    if (mouseEvent.getModifiers() == 16) {
                        LcdScreen.this.selX1 = LcdScreen.this.selX2 = n5;
                        LcdScreen.this.selY1 = LcdScreen.this.selY2 = n6;
                    } else if (mouseEvent.getModifiers() == 4) {
                        // empty if block
                    }
                } else if (LcdScreen.this.tool == "pen") {
                    if (n >= LcdScreen.this.xo & n2 >= LcdScreen.this.yo & n < LcdScreen.this.xo + LcdScreen.this.Width * n3 & n2 < LcdScreen.this.yo + LcdScreen.this.Height * n4) {
                        if (mouseEvent.getModifiers() == 16) {
                            LcdScreen.this.setPoint(n5, n6, LcdScreen.this.penSize);
                        } else if (mouseEvent.getModifiers() == 4) {
                            LcdScreen.this.clrPoint(n5, n6, LcdScreen.this.penSize);
                        }
                    }
                } else if (LcdScreen.this.tool == "line" || LcdScreen.this.tool == "circle" || LcdScreen.this.tool == "rect") {
                    if (n < LcdScreen.this.xo) {
                        n = LcdScreen.this.xo;
                    }
                    if (n2 < LcdScreen.this.xo) {
                        n2 = LcdScreen.this.yo;
                    }
                    if (n > LcdScreen.this.xo + LcdScreen.this.Width * n3) {
                        n = LcdScreen.this.xo + LcdScreen.this.Width * n3;
                    }
                    if (n2 > LcdScreen.this.yo + LcdScreen.this.Height * n4) {
                        n2 = LcdScreen.this.yo + LcdScreen.this.Height * n4;
                    }
                    n5 = (n - LcdScreen.this.xo) / n3;
                    n6 = (n2 - LcdScreen.this.yo) / n4;
                    if (mouseEvent.getModifiers() == 16 || mouseEvent.getModifiers() == 4) {
                        LcdScreen.this.selX1 = LcdScreen.this.selX1 = n5;
                        LcdScreen.this.selY1 = LcdScreen.this.selY2 = n6;
                        if (mouseEvent.getModifiers() == 16) {
                            LcdScreen.this.selColor = Color.black;
                        } else if (mouseEvent.getModifiers() == 4) {
                            LcdScreen.this.selColor = Color.white;
                        }
                    }
                } else if (LcdScreen.this.tool == "text") {
                    if (mouseEvent.getModifiers() == 16) {
                        LcdScreen.this.toolLMClick = true;
                        LcdScreen.this.repaint();
                    } else if (mouseEvent.getModifiers() == 4) {
                        LcdScreen.this.toolLMClick = true;
                        LcdScreen.this.repaint();
                    }
                } else if (LcdScreen.this.tool == "fill" && n >= LcdScreen.this.xo & n2 >= LcdScreen.this.yo & n < LcdScreen.this.xo + LcdScreen.this.Width * n3 & n2 < LcdScreen.this.yo + LcdScreen.this.Height * n4) {
                    if (mouseEvent.getModifiers() == 16) {
                        LcdScreen.this.selColor = Color.black;
                    } else if (mouseEvent.getModifiers() == 4) {
                        LcdScreen.this.selColor = Color.white;
                    }
                    LcdScreen.this.floodFill(n5, n6, LcdScreen.this.selColor);
                    LcdScreen.this.repaint();
                    LcdScreen.this.undoCopy();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = LcdScreen.this.zoom;
                int n4 = LcdScreen.this.zoom;
                int n5 = (n - LcdScreen.this.xo) / n3;
                int n6 = (n2 - LcdScreen.this.yo) / n4;
                if (LcdScreen.this.tool == "pen" && n >= LcdScreen.this.xo & n2 >= LcdScreen.this.yo & n < LcdScreen.this.xo + LcdScreen.this.Width * n3 & n2 < LcdScreen.this.yo + LcdScreen.this.Height * n4) {
                    LcdScreen.this.undoCopy();
                }
                if (LcdScreen.this.tool == "text") {
                    if (mouseEvent.getModifiers() == 16) {
                        LcdScreen.this.drawMyText(n5, n6, 9, Color.black);
                        LcdScreen.this.undoCopy();
                        LcdScreen.this.toolLMClick = false;
                    } else if (mouseEvent.getModifiers() == 4) {
                        LcdScreen.this.drawMyText(n5, n6, 9, Color.white);
                        LcdScreen.this.undoCopy();
                        LcdScreen.this.toolLMClick = false;
                    }
                }
                if (LcdScreen.this.tool == "select") {
                    if (n < LcdScreen.this.xo) {
                        n = LcdScreen.this.xo;
                    }
                    if (n2 < LcdScreen.this.xo) {
                        n2 = LcdScreen.this.yo;
                    }
                    if (n > LcdScreen.this.xo + LcdScreen.this.Width * n3) {
                        n = LcdScreen.this.xo + LcdScreen.this.Width * n3;
                    }
                    if (n2 > LcdScreen.this.yo + LcdScreen.this.Height * n4) {
                        n2 = LcdScreen.this.yo + LcdScreen.this.Height * n4;
                    }
                    n5 = (n - LcdScreen.this.xo) / n3;
                    n6 = (n2 - LcdScreen.this.yo) / n4;
                    LcdScreen.this.statusBar.setMouseXY(n5, n6, LcdScreen.this.Width + " x " + LcdScreen.this.Height);
                    if (mouseEvent.getModifiers() == 16) {
                        LcdScreen.this.selX2 = n5;
                        LcdScreen.this.selY2 = n6;
                        LcdScreen.this.repaint();
                    } else if (mouseEvent.getModifiers() == 4) {
                        // empty if block
                    }
                }
                if (LcdScreen.this.tool == "line" || LcdScreen.this.tool == "circle" || LcdScreen.this.tool == "rect") {
                    if (n < LcdScreen.this.xo) {
                        n = LcdScreen.this.xo;
                    }
                    if (n2 < LcdScreen.this.xo) {
                        n2 = LcdScreen.this.yo;
                    }
                    if (n > LcdScreen.this.xo + LcdScreen.this.Width * n3) {
                        n = LcdScreen.this.xo + LcdScreen.this.Width * n3;
                    }
                    if (n2 > LcdScreen.this.yo + LcdScreen.this.Height * n4) {
                        n2 = LcdScreen.this.yo + LcdScreen.this.Height * n4;
                    }
                    n5 = (n - LcdScreen.this.xo) / n3;
                    n6 = (n2 - LcdScreen.this.yo) / n4;
                    LcdScreen.this.statusBar.setMouseXY(n5, n6, LcdScreen.this.Width + " x " + LcdScreen.this.Height);
                    if (mouseEvent.getModifiers() == 16 || mouseEvent.getModifiers() == 4) {
                        LcdScreen.this.selX2 = n5;
                        LcdScreen.this.selY2 = n6;
                        if (LcdScreen.this.tool == "line") {
                            if (LcdScreen.this.selX2 - LcdScreen.this.selX1 != 0 || LcdScreen.this.selY2 - LcdScreen.this.selY1 != 0) {
                                LcdScreen.this.drawLine(LcdScreen.this.selX1, LcdScreen.this.selY1, LcdScreen.this.selX2, LcdScreen.this.selY2, LcdScreen.this.penSize, LcdScreen.this.selColor);
                                LcdScreen.this.undoCopy();
                            }
                        } else if (LcdScreen.this.tool == "circle") {
                            int n7;
                            if (LcdScreen.this.selX2 < LcdScreen.this.selX1) {
                                n7 = LcdScreen.this.selX1;
                                LcdScreen.this.selX1 = LcdScreen.this.selX2;
                                LcdScreen.this.selX2 = n7;
                            }
                            if (LcdScreen.this.selY2 < LcdScreen.this.selY1) {
                                n7 = LcdScreen.this.selY1;
                                LcdScreen.this.selY1 = LcdScreen.this.selY2;
                                LcdScreen.this.selY2 = n7;
                            }
                            if (LcdScreen.this.selX2 - LcdScreen.this.selX1 != 0 || LcdScreen.this.selY2 - LcdScreen.this.selY1 != 0) {
                                LcdScreen.this.drawCircle(LcdScreen.this.selX1, LcdScreen.this.selY1, LcdScreen.this.selX2 - LcdScreen.this.selX1, LcdScreen.this.selY2 - LcdScreen.this.selY1, LcdScreen.this.penSize, LcdScreen.this.selColor);
                                LcdScreen.this.undoCopy();
                            }
                        } else if (LcdScreen.this.tool == "rect") {
                            int n8;
                            if (LcdScreen.this.selX2 < LcdScreen.this.selX1) {
                                n8 = LcdScreen.this.selX1;
                                LcdScreen.this.selX1 = LcdScreen.this.selX2;
                                LcdScreen.this.selX2 = n8;
                            }
                            if (LcdScreen.this.selY2 < LcdScreen.this.selY1) {
                                n8 = LcdScreen.this.selY1;
                                LcdScreen.this.selY1 = LcdScreen.this.selY2;
                                LcdScreen.this.selY2 = n8;
                            }
                            if (LcdScreen.this.selX2 - LcdScreen.this.selX1 != 0 || LcdScreen.this.selY2 - LcdScreen.this.selY1 != 0) {
                                LcdScreen.this.drawRect(LcdScreen.this.selX1, LcdScreen.this.selY1, LcdScreen.this.selX2 - LcdScreen.this.selX1, LcdScreen.this.selY2 - LcdScreen.this.selY1, LcdScreen.this.penSize, LcdScreen.this.selColor);
                                LcdScreen.this.undoCopy();
                            }
                        }
                        LcdScreen.this.selY2 = 0;
                        LcdScreen.this.selY1 = 0;
                        LcdScreen.this.selX2 = 0;
                        LcdScreen.this.selX1 = 0;
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Graphics graphics = LcdScreen.this.getGraphics();
                graphics.dispose();
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = LcdScreen.this.zoom;
                int n4 = LcdScreen.this.zoom;
                if (n < LcdScreen.this.xo) {
                    n = LcdScreen.this.xo;
                }
                if (n2 < LcdScreen.this.xo) {
                    n2 = LcdScreen.this.yo;
                }
                if (n > LcdScreen.this.xo + LcdScreen.this.Width * n3) {
                    n = LcdScreen.this.xo + LcdScreen.this.Width * n3;
                }
                if (n2 > LcdScreen.this.yo + LcdScreen.this.Height * n4) {
                    n2 = LcdScreen.this.yo + LcdScreen.this.Height * n4;
                }
                int n5 = (n - LcdScreen.this.xo) / n3;
                int n6 = (n2 - LcdScreen.this.yo) / n4;
                if (LcdScreen.this.tool == "text") {
                    LcdScreen.this.selX1 = n5;
                    LcdScreen.this.selY1 = n6;
                    LcdScreen.this.repaint();
                }
                LcdScreen.this.statusBar.setMouseXY(n5, n6, LcdScreen.this.Width + " x " + LcdScreen.this.Height);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Graphics graphics = LcdScreen.this.getGraphics();
                graphics.dispose();
                if (LcdScreen.this.tool == "text") {
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    int n3 = LcdScreen.this.zoom;
                    int n4 = LcdScreen.this.zoom;
                    if (n < LcdScreen.this.xo) {
                        n = LcdScreen.this.xo;
                    }
                    if (n2 < LcdScreen.this.xo) {
                        n2 = LcdScreen.this.yo;
                    }
                    if (n > LcdScreen.this.xo + LcdScreen.this.Width * n3) {
                        n = LcdScreen.this.xo + LcdScreen.this.Width * n3;
                    }
                    if (n2 > LcdScreen.this.yo + LcdScreen.this.Height * n4) {
                        n2 = LcdScreen.this.yo + LcdScreen.this.Height * n4;
                    }
                    int n5 = (n - LcdScreen.this.xo) / n3;
                    int n6 = (n2 - LcdScreen.this.yo) / n4;
                    LcdScreen.this.selX1 = n5;
                    LcdScreen.this.selY1 = n6;
                    LcdScreen.this.repaint();
                } else if (LcdScreen.this.tool == "select") {
                    int n = mouseEvent.getX();
                    int n7 = mouseEvent.getY();
                    int n8 = LcdScreen.this.zoom;
                    int n9 = LcdScreen.this.zoom;
                    if (n < LcdScreen.this.xo) {
                        n = LcdScreen.this.xo;
                    }
                    if (n7 < LcdScreen.this.xo) {
                        n7 = LcdScreen.this.yo;
                    }
                    if (n > LcdScreen.this.xo + LcdScreen.this.Width * n8) {
                        n = LcdScreen.this.xo + LcdScreen.this.Width * n8;
                    }
                    if (n7 > LcdScreen.this.yo + LcdScreen.this.Height * n9) {
                        n7 = LcdScreen.this.yo + LcdScreen.this.Height * n9;
                    }
                    int n10 = (n - LcdScreen.this.xo) / n8;
                    int n11 = (n7 - LcdScreen.this.yo) / n9;
                    if (mouseEvent.getModifiers() == 16) {
                        LcdScreen.this.selX2 = n10;
                        LcdScreen.this.selY2 = n11;
                        LcdScreen.this.repaint();
                    } else if (mouseEvent.getModifiers() == 4) {
                        // empty if block
                    }
                    LcdScreen.this.statusBar.setMouseX1Y1X2Y2(LcdScreen.this.selX1, LcdScreen.this.selY1, LcdScreen.this.selX2, LcdScreen.this.selY2, LcdScreen.this.Width + " x " + LcdScreen.this.Height, LcdScreen.this.tool);
                } else if (LcdScreen.this.tool == "line" || LcdScreen.this.tool == "circle" || LcdScreen.this.tool == "rect") {
                    int n = mouseEvent.getX();
                    int n12 = mouseEvent.getY();
                    int n13 = LcdScreen.this.zoom;
                    int n14 = LcdScreen.this.zoom;
                    if (n < LcdScreen.this.xo) {
                        n = LcdScreen.this.xo;
                    }
                    if (n12 < LcdScreen.this.xo) {
                        n12 = LcdScreen.this.yo;
                    }
                    if (n > LcdScreen.this.xo + LcdScreen.this.Width * n13) {
                        n = LcdScreen.this.xo + LcdScreen.this.Width * n13;
                    }
                    if (n12 > LcdScreen.this.yo + LcdScreen.this.Height * n14) {
                        n12 = LcdScreen.this.yo + LcdScreen.this.Height * n14;
                    }
                    int n15 = (n - LcdScreen.this.xo) / n13;
                    int n16 = (n12 - LcdScreen.this.yo) / n14;
                    if (mouseEvent.getModifiers() == 16 || mouseEvent.getModifiers() == 4) {
                        LcdScreen.this.selX2 = n15;
                        LcdScreen.this.selY2 = n16;
                        LcdScreen.this.repaint();
                    }
                    LcdScreen.this.statusBar.setMouseX1Y1X2Y2(LcdScreen.this.selX1, LcdScreen.this.selY1, LcdScreen.this.selX2, LcdScreen.this.selY2, LcdScreen.this.Width + " x " + LcdScreen.this.Height, LcdScreen.this.tool);
                } else if (LcdScreen.this.tool == "pen") {
                    int n = mouseEvent.getX();
                    int n17 = mouseEvent.getY();
                    int n18 = LcdScreen.this.zoom;
                    int n19 = LcdScreen.this.zoom;
                    if (n >= LcdScreen.this.xo & n17 >= LcdScreen.this.yo & n < LcdScreen.this.xo + LcdScreen.this.Width * n18 & n17 < LcdScreen.this.yo + LcdScreen.this.Height * n19) {
                        int n20 = (n - LcdScreen.this.xo) / n18;
                        int n21 = (n17 - LcdScreen.this.yo) / n19;
                        LcdScreen.this.statusBar.setMouseXY(n20, n21, LcdScreen.this.Width + " x " + LcdScreen.this.Height);
                        if (mouseEvent.getModifiers() == 16) {
                            LcdScreen.this.setPoint(n20, n21, LcdScreen.this.penSize);
                        } else if (mouseEvent.getModifiers() == 4) {
                            LcdScreen.this.clrPoint(n20, n21, LcdScreen.this.penSize);
                        }
                    } else {
                        LcdScreen.this.statusBar.setMouseXY(0, 0, LcdScreen.this.Width + " x " + LcdScreen.this.Height);
                    }
                } else if (LcdScreen.this.tool == "fill") {
                    // empty if block
                }
            }
        });
    }

    public void setPoint(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                this.setPixel(n, n2);
                break;
            }
            case 2: {
                this.setPixel(n, n2);
                this.setPixel(n + 1, n2);
                break;
            }
            case 3: {
                this.setPixel(n, n2);
                this.setPixel(n, n2 + 1);
                break;
            }
            case 4: {
                this.setPixel(n, n2);
                this.setPixel(n + 1, n2);
                this.setPixel(n, n2 + 1);
                this.setPixel(n + 1, n2 + 1);
                break;
            }
            case 5: {
                this.setPixel(n, n2 - 1);
                this.setPixel(n - 1, n2);
                this.setPixel(n, n2);
                this.setPixel(n + 1, n2);
                this.setPixel(n, n2 + 1);
                break;
            }
            default: {
                this.setPixel(n, n2);
            }
        }
    }

    public void clrPoint(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                this.clrPixel(n, n2);
                break;
            }
            case 2: {
                this.clrPixel(n, n2);
                this.clrPixel(n + 1, n2);
                break;
            }
            case 3: {
                this.clrPixel(n, n2);
                this.clrPixel(n, n2 + 1);
                break;
            }
            case 4: {
                this.clrPixel(n, n2);
                this.clrPixel(n + 1, n2);
                this.clrPixel(n, n2 + 1);
                this.clrPixel(n + 1, n2 + 1);
                break;
            }
            case 5: {
                this.clrPixel(n, n2 - 1);
                this.clrPixel(n - 1, n2);
                this.clrPixel(n, n2);
                this.clrPixel(n + 1, n2);
                this.clrPixel(n, n2 + 1);
                break;
            }
            default: {
                this.clrPixel(n, n2);
            }
        }
    }

    public void setPixel(int n, int n2) {
        if (n >= 0 && n < this.Width && n2 >= 0 && n2 < this.Height) {
            this.bImage.setRGB(n, n2, 0);
            int n3 = this.zoom;
            int n4 = this.zoom;
            Graphics graphics = this.getGraphics();
            graphics.setColor(Color.black);
            if (this.zoom > 3 && this.zoomGrid) {
                graphics.fillRect(this.xo + n * n3 + 1, this.yo + n2 * n4 + 1, n3 - 1, n4 - 1);
            } else {
                graphics.fillRect(this.xo + n * n3, this.yo + n2 * n4, n3, n4);
            }
            graphics.dispose();
        }
    }

    public void clrPixel(int n, int n2) {
        if (n >= 0 && n < this.Width && n2 >= 0 && n2 < this.Height) {
            this.bImage.setRGB(n, n2, 0xFFFFFF);
            int n3 = this.zoom;
            int n4 = this.zoom;
            Graphics graphics = this.getGraphics();
            graphics.setColor(new Color(0xFFFFFF));
            if (this.zoom > 3 && this.zoomGrid) {
                graphics.fillRect(this.xo + n * n3 + 1, this.yo + n2 * n4 + 1, n3 - 1, n4 - 1);
            } else {
                graphics.fillRect(this.xo + n * n3, this.yo + n2 * n4, n3, n4);
            }
            graphics.dispose();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n5 = this.zoom;
        int n6 = this.zoom;
        if (this.tool == "select") {
            graphics2D.drawImage(this.bImage, this.xo, this.yo, this.xo + this.Width * this.zoom, this.yo + this.Height * this.zoom, 0, 0, this.Width, this.Height, null);
            int n7 = this.xo + n5 * this.selX1;
            int n8 = this.yo + n6 * this.selY1;
            n4 = this.xo + n5 * this.selX2;
            n3 = this.yo + n6 * this.selY2;
            if (n4 < n7) {
                n2 = n7;
                n7 = n4;
                n4 = n2;
            }
            if (n3 < n8) {
                n2 = n8;
                n8 = n3;
                n3 = n2;
            }
            if (n4 - n7 > 0 && n3 - n8 > 0) {
                n = this.zoom > 3 ? 2 : 1;
                graphics2D.setStroke(new BasicStroke(n));
                graphics2D.setXORMode(Color.white);
                graphics2D.drawRect(n7, n8, n4 - n7, n3 - n8);
                graphics2D.setPaintMode();
            }
        } else if (this.tool == "line" || this.tool == "circle" || this.tool == "rect" || this.tool == "text") {
            if (this.selX2 - this.selX1 == 0 && this.selY2 - this.selY1 == 0) {
                graphics2D.drawImage(this.bImage, this.xo, this.yo, this.xo + this.Width * this.zoom, this.yo + this.Height * this.zoom, 0, 0, this.Width, this.Height, null);
            } else {
                int n9;
                BufferedImage bufferedImage = new BufferedImage(this.Width, this.Height, 1);
                Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
                graphics2D2.drawImage((Image)this.bImage, 0, 0, this);
                graphics2D2.setStroke(new BasicStroke(this.penSize));
                graphics2D2.setColor(this.selColor);
                if (this.tool == "line") {
                    graphics2D2.drawLine(this.selX1, this.selY1, this.selX2, this.selY2);
                } else if (this.tool == "circle") {
                    n4 = this.selX1;
                    n3 = this.selY1;
                    n2 = this.selX2;
                    n = this.selY2;
                    if (n2 < n4) {
                        n9 = n4;
                        n4 = n2;
                        n2 = n9;
                    }
                    if (n < n3) {
                        n9 = n3;
                        n3 = n;
                        n = n9;
                    }
                    graphics2D2.drawOval(n4, n3, n2 - n4, n - n3);
                } else if (this.tool == "rect") {
                    n4 = this.selX1;
                    n3 = this.selY1;
                    n2 = this.selX2;
                    n = this.selY2;
                    if (n2 < n4) {
                        n9 = n4;
                        n4 = n2;
                        n2 = n9;
                    }
                    if (n < n3) {
                        n9 = n3;
                        n3 = n;
                        n = n9;
                    }
                    graphics2D2.drawRect(n4, n3, n2 - n4, n - n3);
                } else if (this.tool == "text" && this.toolLMClick) {
                    graphics2D2.setColor(Color.lightGray);
                    graphics2D2.setFont(this.myFont);
                    graphics2D2.drawString(this.myText, this.selX1, this.selY1);
                }
                graphics2D2.dispose();
                graphics2D.drawImage(bufferedImage, this.xo, this.yo, this.xo + this.Width * this.zoom, this.yo + this.Height * this.zoom, 0, 0, this.Width, this.Height, null);
            }
        } else {
            graphics2D.drawImage(this.bImage, this.xo, this.yo, this.xo + this.Width * this.zoom, this.yo + this.Height * this.zoom, 0, 0, this.Width, this.Height, null);
        }
        if (this.zoom > 3) {
            graphics2D.setStroke(new BasicStroke(1.0f));
            if (this.zoomGrid && !this.Grid) {
                int n10;
                graphics2D.setColor(Color.gray);
                for (n10 = 0; n10 <= this.Height; ++n10) {
                    graphics2D.drawLine(this.xo, this.yo + n6 * n10, this.xo + this.Width * n5, this.yo + n10 * n6);
                }
                for (n10 = 0; n10 <= this.Width; ++n10) {
                    graphics2D.drawLine(this.xo + n10 * n5, this.yo, this.xo + n10 * n5, this.yo + this.Height * n6);
                }
            } else if (!this.zoomGrid && this.Grid) {
                int n11;
                graphics2D.setColor(Color.blue);
                for (n11 = 0; n11 <= this.Height; n11 += this.gridHeight) {
                    graphics2D.drawLine(this.xo, this.yo + n6 * n11, this.xo + this.Width * n5, this.yo + n11 * n6);
                }
                for (n11 = 0; n11 <= this.Width; n11 += this.gridWidth) {
                    graphics2D.drawLine(this.xo + n11 * n5, this.yo, this.xo + n11 * n5, this.yo + this.Height * n6);
                }
            } else if (this.zoomGrid && this.Grid) {
                int n12;
                for (n12 = 0; n12 <= this.Height; ++n12) {
                    graphics2D.setColor(n12 % this.gridHeight == 0 && this.Grid ? Color.blue : Color.gray);
                    graphics2D.drawLine(this.xo, this.yo + n6 * n12, this.xo + this.Width * n5, this.yo + n12 * n6);
                }
                for (n12 = 0; n12 <= this.Width; ++n12) {
                    graphics2D.setColor(n12 % this.gridWidth == 0 && this.Grid ? Color.blue : Color.gray);
                    graphics2D.drawLine(this.xo + n12 * n5, this.yo, this.xo + n12 * n5, this.yo + this.Height * n6);
                }
            }
        }
        graphics2D.dispose();
    }

    public void RShift() {
        int n;
        int n2 = this.selX1;
        int n3 = this.selY1;
        int n4 = this.selX2;
        int n5 = this.selY2;
        if (n4 < n2) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n5 < n3) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        if (n6 == 0 || n7 == 0) {
            n2 = 0;
            n3 = 0;
            n4 = this.Width;
            n5 = this.Height;
            n6 = this.Width;
            n7 = this.Height;
        }
        BufferedImage bufferedImage = new BufferedImage(n6, n7, 1);
        bufferedImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(new Color(0xFFFFFF));
        graphics2D.fillRect(0, 0, n6, n7);
        graphics2D.drawImage(this.bImage, 1, 0, n6, n7, n2, n3, n4 - 1, n5, null);
        graphics2D.dispose();
        this.bImage.createGraphics();
        graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.drawImage(bufferedImage, n2, n3, n4, n5, 0, 0, n6, n7, null);
        graphics2D.dispose();
        this.repaint();
    }

    public void LShift() {
        int n;
        int n2 = this.selX1;
        int n3 = this.selY1;
        int n4 = this.selX2;
        int n5 = this.selY2;
        if (n4 < n2) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n5 < n3) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        if (n6 == 0 || n7 == 0) {
            n2 = 0;
            n3 = 0;
            n4 = this.Width;
            n5 = this.Height;
            n6 = this.Width;
            n7 = this.Height;
        }
        BufferedImage bufferedImage = new BufferedImage(n6, n7, 1);
        bufferedImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(new Color(0xFFFFFF));
        graphics2D.fillRect(0, 0, n6, n7);
        graphics2D.drawImage(this.bImage, 0, 0, n6 - 1, n7, n2 + 1, n3, n4, n5, null);
        graphics2D.dispose();
        this.bImage.createGraphics();
        graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.drawImage(bufferedImage, n2, n3, n4, n5, 0, 0, n6, n7, null);
        graphics2D.dispose();
        this.repaint();
    }

    public void shiftUp() {
        int n;
        int n2 = this.selX1;
        int n3 = this.selY1;
        int n4 = this.selX2;
        int n5 = this.selY2;
        if (n4 < n2) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n5 < n3) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        if (n6 == 0 || n7 == 0) {
            n2 = 0;
            n3 = 0;
            n4 = this.Width;
            n5 = this.Height;
            n6 = this.Width;
            n7 = this.Height;
        }
        BufferedImage bufferedImage = new BufferedImage(n6, n7, 1);
        bufferedImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(new Color(0xFFFFFF));
        graphics2D.fillRect(0, 0, n6, n7);
        graphics2D.drawImage(this.bImage, 0, 0, n6, n7 - 1, n2, n3 + 1, n4, n5, null);
        graphics2D.dispose();
        this.bImage.createGraphics();
        graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.drawImage(bufferedImage, n2, n3, n4, n5, 0, 0, n6, n7, null);
        graphics2D.dispose();
        this.repaint();
    }

    public void shiftDown() {
        int n;
        int n2 = this.selX1;
        int n3 = this.selY1;
        int n4 = this.selX2;
        int n5 = this.selY2;
        if (n4 < n2) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n5 < n3) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        if (n6 == 0 || n7 == 0) {
            n2 = 0;
            n3 = 0;
            n4 = this.Width;
            n5 = this.Height;
            n6 = this.Width;
            n7 = this.Height;
        }
        BufferedImage bufferedImage = new BufferedImage(n6, n7, 1);
        bufferedImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(new Color(0xFFFFFF));
        graphics2D.fillRect(0, 0, n6, n7);
        graphics2D.drawImage(this.bImage, 0, 1, n6, n7, n2, n3, n4, n5 - 1, null);
        graphics2D.dispose();
        this.bImage.createGraphics();
        graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.drawImage(bufferedImage, n2, n3, n4, n5, 0, 0, n6, n7, null);
        graphics2D.dispose();
        this.repaint();
    }

    public void vFlip() {
        int n;
        int n2 = this.selX1;
        int n3 = this.selY1;
        int n4 = this.selX2;
        int n5 = this.selY2;
        if (n4 < n2) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n5 < n3) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        if (n6 == 0 || n7 == 0) {
            n2 = 0;
            n3 = 0;
            n4 = this.Width;
            n5 = this.Height;
            n6 = this.Width;
            n7 = this.Height;
        }
        BufferedImage bufferedImage = new BufferedImage(n6, n7, 1);
        bufferedImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(this.bImage, 0, 0, n6, n7, n2, n5, n4, n3, null);
        graphics2D.dispose();
        this.bImage.createGraphics();
        graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.drawImage(bufferedImage, n2, n3, n4, n5, 0, 0, n6, n7, null);
        graphics2D.dispose();
        this.repaint();
    }

    public void hFlip() {
        int n;
        int n2 = this.selX1;
        int n3 = this.selY1;
        int n4 = this.selX2;
        int n5 = this.selY2;
        if (n4 < n2) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n5 < n3) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        if (n6 == 0 || n7 == 0) {
            n2 = 0;
            n3 = 0;
            n4 = this.Width;
            n5 = this.Height;
            n6 = this.Width;
            n7 = this.Height;
        }
        BufferedImage bufferedImage = new BufferedImage(n6, n7, 1);
        bufferedImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(this.bImage, 0, 0, n6, n7, n4, n3, n2, n5, null);
        graphics2D.dispose();
        this.bImage.createGraphics();
        graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.drawImage(bufferedImage, n2, n3, n4, n5, 0, 0, n6, n7, null);
        graphics2D.dispose();
        this.repaint();
    }

    public int Crop() {
        int n;
        int n2 = this.selX1;
        int n3 = this.selY1;
        int n4 = this.selX2;
        int n5 = this.selY2;
        this.selY2 = 0;
        this.selY1 = 0;
        this.selX2 = 0;
        this.selX1 = 0;
        if (n4 < n2) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n5 < n3) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        if (n6 == 0 || n7 == 0) {
            return -1;
        }
        BufferedImage bufferedImage = new BufferedImage(n6, n7, 1);
        bufferedImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(this.bImage, 0, 0, n6, n7, n2, n3, n4, n5, null);
        graphics2D.dispose();
        this.bImage = bufferedImage;
        this.Width = n6;
        this.Height = n7;
        int n8 = this.zoom;
        int n9 = this.zoom;
        this.setPreferredSize(new Dimension(this.Width * n8 + 40, this.Height * n9 + 40));
        this.revalidate();
        this.repaint();
        return 0;
    }

    public void negative() {
        int n;
        int n2 = this.selX1;
        int n3 = this.selY1;
        int n4 = this.selX2;
        int n5 = this.selY2;
        if (n4 < n2) {
            n = n2;
            n2 = n4;
            n4 = n;
        }
        if (n5 < n3) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        if (n6 == 0 || n7 == 0) {
            n2 = 0;
            n3 = 0;
            n4 = this.Width;
            n5 = this.Height;
            n6 = this.Width;
            n7 = this.Height;
        }
        BufferedImage bufferedImage = new BufferedImage(n6, n7, 1);
        bufferedImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(new Color(0xFFFFFF));
        graphics2D.fillRect(0, 0, n6, n7);
        graphics2D.drawImage(this.bImage, 0, 0, n6, n7, n2, n3, n4, n5, null);
        graphics2D.dispose();
        RescaleOp rescaleOp = new RescaleOp(-1.0f, 255.0f, null);
        BufferedImage bufferedImage2 = rescaleOp.filter(bufferedImage, null);
        this.bImage.createGraphics();
        graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.drawImage(bufferedImage2, n2, n3, n4, n5, 0, 0, n6, n7, null);
        graphics2D.dispose();
        this.repaint();
    }

    public void _negative() {
        for (int i = 0; i < this.Width; ++i) {
            for (int j = 0; j < this.Height; ++j) {
                if ((this.bImage.getRGB(i, j) & 0xFFFFFF) == 0) {
                    this.bImage.setRGB(i, j, 0xFFFFFF);
                    continue;
                }
                this.bImage.setRGB(i, j, 0);
            }
        }
        this.repaint();
    }

    public void convert2BandW(int n) {
        ColorConvertOp colorConvertOp = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        BufferedImage bufferedImage = colorConvertOp.filter(this.bImage, null);
        this.bImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.setColor(new Color(0xFFFFFF));
        graphics2D.fillRect(0, 0, this.Width, this.Height);
        graphics2D.dispose();
        for (int i = 0; i < this.Height; ++i) {
            for (int j = 0; j < this.Width; ++j) {
                int n2 = bufferedImage.getRGB(j, i) & 0xFFFFFF;
                int n3 = ((n2 & 0xFF) + ((n2 & 0xFF00) >> 8) + ((n2 & 0xFF0000) >> 16)) / 3;
                this.bImage.setRGB(j, i, n3 < n ? 0 : 0xFFFFFF);
            }
        }
        this.repaint();
    }

    public void drawMyText(int n, int n2, int n3, Color color) {
        this.bImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.setColor(color);
        graphics2D.setFont(this.myFont);
        graphics2D.drawString(this.myText, n, n2);
        graphics2D.dispose();
    }

    public void drawRect(int n, int n2, int n3, int n4, int n5, Color color) {
        this.bImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.setStroke(new BasicStroke(n5));
        graphics2D.setColor(color);
        graphics2D.drawRect(n, n2, n3, n4);
        graphics2D.dispose();
    }

    public void drawCircle(int n, int n2, int n3, int n4, int n5, Color color) {
        this.bImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.setStroke(new BasicStroke(n5));
        graphics2D.setColor(color);
        graphics2D.drawOval(n, n2, n3, n4);
        graphics2D.dispose();
    }

    public void drawLine(int n, int n2, int n3, int n4, int n5, Color color) {
        this.bImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)this.bImage.getGraphics();
        graphics2D.setStroke(new BasicStroke(n5));
        graphics2D.setColor(color);
        graphics2D.drawLine(n, n2, n3, n4);
        graphics2D.dispose();
    }

    public void floodFill(int n, int n2, Color color) {
        int[][] nArray = new int[this.Width * this.Height][2];
        int n3 = 0;
        int n4 = color.getRGB() & 0xFFFFFF;
        if ((this.bImage.getRGB(n, n2) & 0xFFFFFF) == n4) {
            return;
        }
        int n5 = this.bImage.getRGB(n, n2) & 0xFFFFFF;
        this.bImage.setRGB(n, n2, n4);
        nArray[n3][0] = n;
        nArray[n3][1] = n2;
        ++n3;
        for (int i = 0; i < n3; ++i) {
            int n6 = nArray[i][0];
            int n7 = nArray[i][1];
            if (n6 >= 0 && n6 < this.Width && n7 - 1 >= 0 && n7 - 1 < this.Height && (this.bImage.getRGB(n6, n7 - 1) & 0xFFFFFF) == n5) {
                this.bImage.setRGB(n6, n7 - 1, n4);
                nArray[n3][0] = n6;
                nArray[n3][1] = n7 - 1;
                ++n3;
            }
            if (n6 >= 0 && n6 < this.Width && n7 + 1 >= 0 && n7 + 1 < this.Height && (this.bImage.getRGB(n6, n7 + 1) & 0xFFFFFF) == n5) {
                this.bImage.setRGB(n6, n7 + 1, n4);
                nArray[n3][0] = n6;
                nArray[n3][1] = n7 + 1;
                ++n3;
            }
            if (n6 + 1 >= 0 && n6 + 1 < this.Width && n7 >= 0 && n7 < this.Height && (this.bImage.getRGB(n6 + 1, n7) & 0xFFFFFF) == n5) {
                this.bImage.setRGB(n6 + 1, n7, n4);
                nArray[n3][0] = n6 + 1;
                nArray[n3][1] = n7;
                ++n3;
            }
            if (n6 - 1 < 0 || n6 - 1 >= this.Width || n7 < 0 || n7 >= this.Height || (this.bImage.getRGB(n6 - 1, n7) & 0xFFFFFF) != n5) continue;
            this.bImage.setRGB(n6 - 1, n7, n4);
            nArray[n3][0] = n6 - 1;
            nArray[n3][1] = n7;
            ++n3;
        }
    }
}

