/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class FontChooser2
extends JDialog {
    protected Font resultFont;
    protected String resultName;
    protected int resultSize;
    protected boolean isBold;
    protected boolean isItalic;
    protected String displayText = "Qwerty Yuiop";
    protected String[] fontList;
    protected JList fontNameChoice;
    protected List fontSizeChoice;
    Checkbox bold;
    Checkbox italic;
    protected String[] fontSizes = new String[]{"7", "8", "9", "10", "11", "12", "13", "14", "16", "17", "18", "20", "24", "30", "36", "40", "48", "60", "72"};
    protected static final int DEFAULT_SIZE = 4;
    protected JLabel previewArea;

    public FontChooser2(Font font) {
        super((Frame)null, "Font Chooser", true);
        Container container = this.getContentPane();
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        int n = 0;
        String string = font.getFamily();
        for (int i = 0; i < this.fontList.length; ++i) {
            defaultListModel.addElement(this.fontList[i]);
            if (!this.fontList[i].equalsIgnoreCase(string)) continue;
            n = i;
        }
        this.fontNameChoice = new JList(defaultListModel);
        this.fontNameChoice.setSelectionMode(1);
        this.fontNameChoice.setLayoutOrientation(2);
        this.fontNameChoice.setVisibleRowCount(-1);
        this.fontNameChoice.setSelectedIndex(n);
        this.fontNameChoice.ensureIndexIsVisible(n);
        this.fontNameChoice.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FontChooser2.this.previewFont();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.fontNameChoice);
        jScrollPane.setPreferredSize(new Dimension(250, 160));
        panel.add(jScrollPane);
        this.fontSizeChoice = new List(8);
        panel.add(this.fontSizeChoice);
        this.fontSizeChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser2.this.previewFont();
            }
        });
        for (int i = 0; i < this.fontSizes.length; ++i) {
            this.fontSizeChoice.add(this.fontSizes[i]);
        }
        this.fontSizeChoice.select(4);
        container.add((Component)panel, "North");
        Panel panel2 = new Panel();
        panel.add(panel2);
        panel2.setLayout(new GridLayout(0, 1));
        this.bold = new Checkbox("Bold", false);
        panel2.add(this.bold);
        this.italic = new Checkbox("Italic", false);
        panel2.add(this.italic);
        this.previewArea = new JLabel(this.displayText, 0);
        this.previewArea.setSize(200, 50);
        container.add((Component)this.previewArea, "Center");
        Panel panel3 = new Panel();
        JButton jButton = new JButton("Apply");
        panel3.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser2.this.previewFont();
                FontChooser2.this.dispose();
                FontChooser2.this.setVisible(false);
            }
        });
        JButton jButton2 = new JButton("Preview");
        panel3.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser2.this.previewFont();
            }
        });
        JButton jButton3 = new JButton("Cancel");
        panel3.add(jButton3);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser2.this.resultFont = null;
                FontChooser2.this.resultName = null;
                FontChooser2.this.resultSize = 0;
                FontChooser2.this.isBold = false;
                FontChooser2.this.isItalic = false;
                FontChooser2.this.dispose();
                FontChooser2.this.setVisible(false);
            }
        });
        container.add((Component)panel3, "South");
        this.previewFont();
        this.pack();
        this.setLocation(100, 100);
    }

    protected void previewFont() {
        this.resultName = (String)this.fontNameChoice.getSelectedValue();
        String string = this.fontSizeChoice.getSelectedItem();
        int n = Integer.parseInt(string);
        this.isBold = this.bold.getState();
        this.isItalic = this.italic.getState();
        int n2 = 0;
        if (this.isBold) {
            n2 = 1;
        }
        if (this.isItalic) {
            n2 |= 2;
        }
        this.resultFont = new Font(this.resultName, n2, n);
        this.previewArea.setFont(this.resultFont);
        this.pack();
    }

    public String getSelectedName() {
        return this.resultName;
    }

    public int getSelectedSize() {
        return this.resultSize;
    }

    public Font getSelectedFont() {
        return this.resultFont;
    }
}

